float4x4 matView;
float4x4 matProjection;
float4x4 matViewProjection;
float4x4 matWorld;
float4x4 matWorldView;
float4x4 matWorldViewProjection;
float4x4 matMirror;

float time; 
float const0;
float const1;

float3 CameraPosition;
float3 CameraTarget;

bool    usealpha;
texture tex0;
texture tex1;
texture tex2;

sampler sTex0 = sampler_state
{
	texture = (tex0);
	MipFilter = Linear;
	MagFilter = Linear;
	MinFilter = Linear;
	
	AddressU = WRAP;
	AddressV = WRAP;
};

sampler sTex1 = sampler_state
{
	texture = (tex1);
	MipFilter = Linear;
	MagFilter = Linear;
	MinFilter = Linear;
	
	AddressU = WRAP;
	AddressV = WRAP;
};

sampler sTex2 = sampler_state
{
	texture = (tex2);
	MipFilter = Linear;
	MagFilter = Linear;
	MinFilter = Linear;
	
	AddressU = WRAP;
	AddressV = WRAP;
};

struct VS_INPUT 
{
	float4 pos : POSITION;
	float3 norm : NORMAL;
	float2 tex0 : TEXCOORD0;
};

struct VS_OUTPUT
{
	float4 pos : POSITION;
	float4 diffuse : COLOR0;
	float2 tex0 : TEXCOORD0;
	float2 tex1 : TEXCOORD1;
};

VS_OUTPUT DiscoFloorBaseVS(VS_INPUT i)
{
	VS_OUTPUT o;
	o.pos = mul(i.pos, matWorldViewProjection);
	o.diffuse = float4(1.f, 0.f, 0.f, 1.f);
	o.tex0 = i.tex0;
	o.tex1 = mul(i.tex0, matView);
	o.diffuse.rgb = i.norm.xyz;
	o.diffuse.a = 1.f;
	return o; 
}

VS_OUTPUT DiscoBoxReflectionVS(VS_INPUT i)
{
	VS_OUTPUT o;
	o.pos = mul(i.pos, matMirror);
	o.diffuse = float4(1.f, 0.f, 0.f, 1.f);
	o.tex0 = i.tex0;
	o.tex1 = mul(i.tex0, matView);
	o.diffuse.rgb = i.norm.xyz;
	o.diffuse.a = .4f;
	return o; 
}


VS_OUTPUT DiscoFloorTileSpecularVS(VS_INPUT i)
{
	VS_OUTPUT o;
	o.pos = mul(i.pos, matWorldViewProjection);
	o.diffuse = float4(1.f, 0.f, 0.f, 1.f);
	o.tex0 = i.tex0*19.f;
	o.tex1 = mul(i.tex0, matView);
	o.diffuse.rgb = i.norm.xyz;
	o.diffuse.a = 1.f;
	return o; 
}

VS_OUTPUT DiscoFloorTileSpecularReflectionVS(VS_INPUT i)
{
	VS_OUTPUT o;
	o.pos = mul(i.pos, matMirror);
	o.diffuse = float4(1.f, 0.f, 0.f, 1.f);
	o.tex0 = i.tex0*19.f;
	o.tex1 = mul(i.tex0, matView);
	o.diffuse.rgb = i.norm.xyz;
	o.diffuse.a = .4f;
	return o; 
}

VS_OUTPUT DancerReflectionVS(VS_INPUT i)
{
	VS_OUTPUT o;
	o.tex0.y = i.tex0.y;
	o.tex0.x = i.tex0.x + (i.tex0.y*((.002f*(i.pos.z+128))*sin((i.tex0.y*3)+const0)));
	o.pos = mul(i.pos, matMirror);
	o.tex1 = i.tex0;
	o.diffuse = float4(1.f, 0.f, 0.f, 1.f);
	return o;
};

VS_OUTPUT DancerPlainVS(VS_INPUT i)
{
	VS_OUTPUT o;
	o.tex0.y = i.tex0.y;
	//o.tex0.x = i.tex0.x + ((.01f*(i.pos.x))*sin((i.tex0.x*3)+const0));
	o.tex0.x = i.tex0.x + (i.tex0.y*((.002f*(i.pos.z+128))*sin((i.tex0.y*-3)+const0)));
	o.pos = mul(i.pos, matWorldViewProjection);
	o.tex1 = i.tex0;
	o.diffuse = float4(1.f, 0.f, 0.f, 1.f);
	return o;
};

VS_OUTPUT BackGroundVS(VS_INPUT i)
{
	VS_OUTPUT o;
	o.pos = mul(i.pos, matProjection);
	o.tex0 = i.tex0*19.f;
	o.tex1.x = i.tex0.x;
	o.tex1.y = i.tex0.y+time;
	o.diffuse = float4(1.f, 0.f, 0.f, 1.f);
	return o;
};

VS_OUTPUT AdditiveOverlayVS(VS_INPUT i)
{
	VS_OUTPUT o;
	o.pos = mul(i.pos, matProjection);
	o.tex0 = i.tex0;
	o.tex1 = i.tex0;
	o.diffuse = float4(1.f, 0.f, 0.f, 1.f);
	return o;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

struct PS_INPUT
{
	float2 tex0 : TEXCOORD0;
	float2 tex1 : TEXCOORD1;
	float4 diffuse : COLOR0;
};

float4 DiscoFloorBasePS(PS_INPUT i) : COLOR0
{
	return (tex2D(sTex0, float2(i.diffuse.x+(time*.1f), i.diffuse.y+(time*.1f)))+tex2D(sTex1, i.tex1))*i.diffuse.a;
}

float4 DiscoFloorTileSpecularPS(PS_INPUT i) : COLOR0
{
	float4 color = tex2D(sTex0, i.tex0);
	float4 spec  = tex2D(sTex1, i.tex1);
	color.rgb += spec.rgb;
	
	color.rgba *= i.diffuse.a;
	return color;
}

float4 DancerReflectionPS(PS_INPUT i) : COLOR0
{
	float4 color = tex2D(sTex0, i.tex0);
	color.rgb *= .7f;
	color.a *= .2f;
	return color;
}

float4 DancerPlainPS(PS_INPUT i) : COLOR0
{
	return tex2D(sTex0, i.tex0);
}

float4 AdditiveOverlayPS(PS_INPUT i) : COLOR0
{
	return tex2D(sTex0, float2(i.tex0.x+const1, i.tex0.y))*const0;
}

float4 BackGroundPS(PS_INPUT i) : COLOR0
{
	float4 color = tex2D(sTex0, i.tex0);
	float4 bg = tex2D(sTex1, i.tex1);
	color.rgb += bg.rgb*(1-color.a);
	color.a = 1.f;
	return color;
}

float4 DiscoBoxPS(PS_INPUT i) : COLOR0
{
	float4 base = tex2D(sTex0, float2(i.diffuse.x+(time*.1f), i.diffuse.y+(time*.1f)));
	//float4 specular = tex2D(sTex1, float2(i.diffuse.z*.2f,i.diffuse.w*.2f));
	float4 tile = tex2D(sTex1, i.tex0);
	
	tile += ((base*(1-tile.a))*(.05f+const1));
	tile.rgb *= i.diffuse.a;
	tile.a = 1.f;
	return tile;//base+specular+tile;
}

float4 DiscoBox2PS(PS_INPUT i) : COLOR0
{
	float4 base = tex2D(sTex0, float2(i.diffuse.x+(time*.1f), i.diffuse.y+(time*.1f)));
	//float4 specular = tex2D(sTex1, float2(i.diffuse.z*.2f,i.diffuse.w*.2f));
	float4 tile = tex2D(sTex1, i.tex0);
	
	tile += ((base*(1-tile.a))*(.05f+const1));
	//tile.rgb *= .5f;
	tile.a = .65f;
	return tile;//base+specular+tile;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

technique DiscoFloor
{
	pass BaseColor
	{
		VertexShader = compile vs_2_0 DiscoFloorBaseVS();	
		PixelShader  = compile ps_2_0 DiscoFloorBasePS();
	}
	
	pass Finish
	{
		VertexShader = compile vs_2_0 DiscoFloorTileSpecularVS();	
		PixelShader  = compile ps_2_0 DiscoFloorTileSpecularPS();
	} 
	
	pass Reflection1
	{
		VertexShader = compile vs_2_0 DiscoBoxReflectionVS();	
		PixelShader  = compile ps_2_0 DiscoFloorBasePS();
	}
	
	pass Reflection2
	{
		VertexShader = compile vs_2_0 DiscoFloorTileSpecularReflectionVS();	
		PixelShader  = compile ps_2_0 DiscoFloorTileSpecularPS();
	}
}

technique DiscoDancer
{
	pass Reflection
	{
		VertexShader = compile vs_2_0 DancerReflectionVS();
		PixelShader  = compile ps_2_0 DancerReflectionPS();
	}
	
	pass Dancer
	{
		VertexShader = compile vs_2_0 DancerPlainVS();
		PixelShader  = compile ps_2_0 DancerPlainPS();
	}
}

technique BackGround
{
	pass p0
	{
		VertexShader = compile vs_2_0 BackGroundVS();
		PixelShader  = compile ps_2_0 BackGroundPS();
	}
}

technique DiscoBox
{
	pass BoxReflection
	{
		VertexShader = compile vs_2_0 DiscoBoxReflectionVS();	
		PixelShader  = compile ps_2_0 DiscoBoxPS();
	}
	
	pass Box
	{
		VertexShader = compile vs_2_0 DiscoFloorBaseVS();
		PixelShader  = compile ps_2_0 DiscoBoxPS();
	}

}

technique DiscoBox2
{
	pass BoxReflection
	{
		VertexShader = compile vs_2_0 DiscoBoxReflectionVS();	
		PixelShader  = compile ps_2_0 DiscoBox2PS();
	}
	
	pass Box
	{
		VertexShader = compile vs_2_0 DiscoFloorBaseVS();
		PixelShader  = compile ps_2_0 DiscoBoxPS();
	}

}

technique AdditiveOverlay
{
	pass p0
	{
		VertexShader = compile vs_2_0 AdditiveOverlayVS();
		PixelShader  = compile ps_2_0 AdditiveOverlayPS();
	}
}
